<?php

namespace App\Http\Controllers\Therapist;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Slot;
use App\Models\Service;
use App\Models\ServiceFeeStructure;
use App\Models\WorkingHours;
use Illuminate\Database\QueryException;
use Carbon\CarbonPeriod;
use Carbon\Carbon;
use App\Models\SlotShedule;
use App\Models\Therapist;
use App\Models\Appointments;
use App\Models\Leave;

class SlotController extends Controller
{
    public function slot(Request $request)
    {

        $data = Slot::select('id', 'break_duration', 'call_duration')->where('therapist_id', auth()->user()->id)->first();
        $hours = [];

        if ($data != null) {
            foreach (days() as $day) {
                $i = 0;
                foreach (WorkingHours::select('id', 'day', 'start_time', 'end_time')->where('slot_id', $data->id)->get() as $key => $item) {
                    if ($day == $item->day) {
                        $hours[$day][$i] = $item;
                        $i++;
                    }
                }
            }

            return response()->json(
                array(
                    'status' => true,
                    'days' => days(),
                    'slot' => $data,
                    'working-time' => $hours,
                    'statuscode' => 200
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $data,
                    'statuscode' => 200
                ),
                200
            );
        }
    }
    public function saveSlot(Request $request)
    {

        try {
            $call_duration = 60;
            $exist = Slot::where('therapist_id', $request->id)->first();
            if ($request->id && $exist != null) {

                $params = [
                    'therapist_id' => auth()->user()->id,
                    'break_duration' =>  $request->break_time,
                    'call_duration' =>  $call_duration
                ];

                $res = Slot::where('id', $request->id)
                    ->update($params);
                if ($res) {
                    $slots = [];
                    $workingHours = count($request->day);

                    foreach ($request->day as $i => $x) {
                        if (isset($request->slot_id[$i])) {
                            $params = [
                                // 'service_id' =>  $request->service[$i],
                                'day' => $request->day[$i],
                                'start_time' =>  $request->start_time[$i],
                                'end_time' => $request->end_time[$i]
                            ];
                            $res = WorkingHours::where('id', $request->slot_id[$i])
                                ->update($params);
                            $slot_id = $request->slot_id[$i];
                            $del_slot = SlotShedule::where('slot_id', $slot_id)->get();
                            foreach ($del_slot as $item) {
                                $del = SlotShedule::where('id', $item->id)->delete();
                            }
                        } else {
                            $workingHours = new WorkingHours();
                            $workingHours->slot_id = $request->id;
                            // $workingHours->service_id = $request->service[$i];
                            $workingHours->day = $request->day[$i];
                            $workingHours->start_time = $request->start_time[$i];
                            $workingHours->end_time = $request->end_time[$i];
                            $workingHours->save();

                            $slot_id = $workingHours->id;
                        }
                        $startTime = date("H:i", strtotime($request->start_time[$i]));
                        $endTime = date("H:i", strtotime($request->end_time[$i]));
                        $service = ServiceFeeStructure::where('provider_category_id', $request->provider_category)->get();

                        foreach ($service as $item) {
                            // $serviceDuration = date("i", strtotime($request->duration));
                            $serviceDuration = $call_duration;
                            $breakInterval = $request->break_time;
                            $breakTime = $breakInterval + $serviceDuration;
                            $breakTime = $breakTime . ' minutes';

                            $slots = slots($startTime, $breakTime, $endTime);

                            $data = [
                                'slot_id' => $slot_id,
                                'call_method_id' => $item->call_method_id,
                                'slots' =>  json_encode($slots)
                            ];
                            $slotShedule = SlotShedule::insert($data);
                        }
                    }


                    return response()->json(
                        array(
                            'status' => true,
                            'data' => "Slot updated succesfully ",
                            'statuscode' => 200
                        ),
                        200
                    );
                } else {
                    return response()->json(
                        array(
                            'status' => false,
                            'data' => "Something went wrong",
                            'statuscode' => 200
                        ),
                        200
                    );
                }
            } else {
                $slot = new Slot();
                $slot->therapist_id = auth()->user()->id;
                $slot->break_duration = $request->break_time;
                $slot->call_duration = $call_duration;
                $slot->save();

                if ($slot) {
                    $slots = [];
                    $workingHours = count($request->day);
                    // foreach ($request->day as $j => $d) {

                    foreach ($request->day as $i => $x) {

                        $workingHours = new WorkingHours();
                        $workingHours->slot_id = $slot->id;
                        // $workingHours->service_id = $request->service[$i];
                        $workingHours->day = $request->day[$i];
                        $workingHours->start_time = $request->start_time[$i];
                        $workingHours->end_time = $request->end_time[$i];
                        $workingHours->save();

                        $startTime = date("H:i", strtotime($request->start_time[$i]));
                        $endTime = date("H:i", strtotime($request->end_time[$i]));
                        $service = ServiceFeeStructure::where('provider_category_id', $request->provider_category)->get();

                        foreach ($service as $item) {
                            // $serviceDuration = date("i", strtotime($request->duration));
                            $serviceDuration = $call_duration;
                            $breakInterval = $request->break_time;
                            $breakTime = $breakInterval + $serviceDuration;
                            $breakTime = $breakTime . ' minutes';

                            $slots = slots($startTime, $breakTime, $endTime);

                            $data = [
                                'slot_id' => $workingHours->id,
                                'call_method_id' => $item->call_method_id,
                                'slots' =>  json_encode($slots)
                            ];
                            $slotShedule = SlotShedule::insert($data);
                        }
                    }
                    // }

                    return response()->json(
                        array(
                            'status' => true,
                            'data' => "Slot succesfully added",
                            'statuscode' => 200
                        ),
                        200
                    );
                } else {
                    return response()->json(
                        array(
                            'status' => false,
                            'data' => "Something went wrong",
                            'statuscode' => 200
                        ),
                        200
                    );
                }
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function searchSlot(Request $request)
    {

        $current_date = date("Y-m-d");
        $current_time = date("H:i");
        $html = '';
        $data = [];
        $booking_date = date("Y-m-d", strtotime($request->bookingDate));
        $error = 'No slots Found';
        $day = Carbon::createFromFormat('Y-m-d', $request->bookingDate)->format('l');
        $appoinment = Appointments::select('Appointment_Type', 'service_id')->where('id', $request->appoinment_id)->first();
        $service = $appoinment->service;

        $slot = Slot::where('therapist_id', $request->therapist)->first();

        if ($slot) {
            $workinghours = WorkingHours::where('slot_id', $slot->id)
                ->where('day', $day)
                ->first();


            if ($workinghours) {

                $slotlist = SlotShedule::where('slot_id', $workinghours->id)->where('call_method_id', $appoinment->Appointment_Type)->first();

                if ($slotlist) {
                    $i = 0;
                    $j = 0;
                    foreach (json_decode($slotlist->slots) as $key => $x) {
                        //***** */
                        $slot_flag = 0;
                        $bookedslots = Appointments::where('therapist_id', $request->therapist)->where('Appointment_Date', $booking_date)->get();
                        if ($bookedslots) {
                            foreach ($bookedslots as $bookedslot) {
                                $booked_slotlist = SlotShedule::where('id', $bookedslot->slot_id)->first();
                                $flag = 0;
                                $next_booked_slot = '';
                                $prev_slot = '';
                                $prev = '';

                                foreach (json_decode($booked_slotlist->slots) as $k => $bs) {
                                    if ($bookedslot->Appointment_Time == $bs) {

                                        $flag = 1;
                                        continue;
                                    } else {
                                        if ($flag == 1) {
                                            $prev = $prev_slot;
                                            $next_booked_slot = $bs;
                                            break;
                                        }
                                    }
                                    $prev_slot = $bs;
                                }
                                $prev = $prev_slot;

                                $time1  = date("H:i", strtotime($bookedslot->Appointment_Time));
                                $time2 = date("H:i", strtotime($next_booked_slot));
                                $time3 = date("H:i", strtotime($prev));
                                $checkedtime = date("H:i", strtotime($x));

                                if (($checkedtime >= $time1 && $checkedtime < $time2) || ($checkedtime > $time3 && $checkedtime <= $time1)) {
                                    $slot_flag = 1;
                                    break;
                                }
                            }
                        }
                        if ($slot_flag == 1) {

                            continue;
                        }
                        //*** */
                        $givenDateTime = date("H:i", strtotime($x));


                        if ($current_date == $request->bookingDate) {

                            if ($current_time < $givenDateTime) {

                                $data[$i]['slot_id'] = $slotlist->id;
                                $booked = Appointments::where('slot_id', $slotlist->id)->where('Appointment_Time', $x)->where('Appointment_Date', $booking_date)->first();
                                $data[$i]['slots'] = $x;
                                if ($booked) {
                                    $data[$i]['slot_status'] = $booked->Appointment_Status;
                                } else {
                                    $data[$i]['slot_status'] = 'Available';
                                }
                                $i++;
                            }
                        } else {

                            $data[$j]['slot_id'] = $slotlist->id;
                            $booked = Appointments::where('slot_id', $slotlist->id)->where('Appointment_Time', $x)->where('Appointment_Date', $booking_date)->first();
                            $data[$j]['slots'] = $x;
                            if ($booked) {
                                $data[$j]['slot_status'] = $booked->Appointment_Status;
                            } else {
                                $data[$j]['slot_status'] = 'Available';
                            }
                            $j++;
                        }
                    }

                    return response()->json(
                        array(
                            'status' => True,
                            'data' => $data
                        ),
                        200
                    );
                } else {

                    return response()->json(
                        array(
                            'status' => False,
                            'data' => $error
                        ),
                        200
                    );
                }
            } else {
                return response()->json(
                    array(
                        'status' => False,
                        'data' => $error
                    ),
                    200
                );
            }
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $error
                ),
                200
            );
        }

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function deleteSlotHour(Request $request)
    {

        $res = WorkingHours::where('id', $request->working_time_id)->delete();
        if (!empty($res)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => "Data deleted Successfully"
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => "Something went wrong"
                ),
                200
            );
        }
    }

    public function saveLeave(Request $request)
    {
        try {
            $leave = new Leave();
            $leave->therapist_id = auth()->user()->id;
            $leave->leave_from = date("y-m-d", strtotime($request->leave_from));
            $leave->leave_to = date("y-m-d", strtotime($request->leave_to));
            $leave->reason = $request->reason;
            $leave->duration = $request->duration;
            $leave->save();

            if ($leave) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Leave  Added Successfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
            // return $e->getMessage();
        }
    }

    public function getLeave(Request $request)
    {
        try {
            $data = Leave::where('therapist_id', auth()->user()->id)->get();

            if ($data) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => $data
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
            // return $e->getMessage();
        }
    }
}
